;Keypad Routines

Keypad_Scan:	
			;reset temp output register
			clr r18
			
			;test row 0
			in r16,PORTB
			sbr r16,0b11110000
			cbr r16,0b00010000
			out PORTB,r16		;R0 = 0

			nop

			in r16,PINB
			in r17,PIND

			sbrs r17,2
			ldi r18,'1'

			sbrs r17,3
			ldi r18,'2'

			sbrs r16,2
			ldi r18,'3'

			;test row 1
			in r16,PORTB
			sbr r16,0b11110000
			cbr r16,0b00100000
			out PORTB,r16		;R1 = 0

			nop

			in r16,PINB
			in r17,PIND

			sbrs r17,2
			ldi r18,'4'

			sbrs r17,3
			ldi r18,'5'

			sbrs r16,2
			ldi r18,'6'

			;test row 2
			in r16,PORTB
			sbr r16,0b11110000
			cbr r16,0b01000000
			out PORTB,r16		;R2 = 0

			nop

			in r16,PINB
			in r17,PIND

			sbrs r17,2
			ldi r18,'7'

			sbrs r17,3
			ldi r18,'8'

			sbrs r16,2
			ldi r18,'9'

			;test row 3
			in r16,PORTB
			sbr r16,0b11110000
			cbr r16,0b10000000
			out PORTB,r16		;R4 = 0

			nop

			in r16,PINB
			in r17,PIND

			sbrs r17,2
			ldi r18,'*'

			sbrs r17,3
			ldi r18,'0'

			sbrs r16,2
			ldi r18,'#'

			
			mov r16,r18					;move keypad value to r16

			sts Keypad_Scan_Key_Val,r16	;Save Key

			tst r16
			brne Keypad_Scan_T
			
			rjmp Keypad_Scan_End		;End if no key pressed

Keypad_Scan_T:
			Set_FIFO_Address Keypad_FIFO
			call FIFO_Write_Circ		;Write Key to FIFO

			mov r17,DC3_B0
			lsr r17						;r17=DC3,SK

			breq Keypad_Scan_Action		;do not send keys if SK=00

			cpi r17,1
			brne Keypad_Scan_B

			;SK=01 (Send keypress FIFO after #)
			cpi r16,'#'
			brne Keypad_Scan_Action

			ld r19,Z					;Get Keypad FIFO counter value

			Set_FIFO_Address USART_TX_FIFO
			ldi r16,DC3
			call FIFO_Write						;DC3
			
Keypad_Scan_A:
			Set_FIFO_Address Keypad_FIFO
			call FIFO_Read

			Set_FIFO_Address USART_TX_FIFO
			call FIFO_Write						;Key_n

			dec r19
			brne Keypad_Scan_A

			ldi r16,ETB
			call FIFO_Write						;ETB

			rjmp Keypad_Scan_Action

Keypad_Scan_B:
			cpi r17,2
			brne Keypad_Scan_C

			;SK=10 (Send keypresses as they occur)

			Set_FIFO_Address USART_TX_FIFO

			ldi r16,DC3							;DC3
			call FIFO_Write

			lds r16,Keypad_Scan_Key_Val			;Key
			call FIFO_Write

			ldi r16,ETB							;ETB
			call FIFO_Write

			rjmp Keypad_Scan_Action


Keypad_Scan_C:
			;SK=11 (Do not send keypresses)
			rjmp Keypad_Scan_Action


Keypad_Scan_Action:
			mov r16,DC2_B0
			sbrs r16,KPC
			rjmp Keypad_Scan_End			;Exit if KPC=0

			mov r16,DC1_B0
			cbr r16,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)

			brne Keypad_Scan_Action_A

			rjmp Keypad_Scan_End			;Exit if VD=00

Keypad_Scan_Action_A:
			lds ZL,Keypad_Scan_Jump_Adr
			lds ZH,(Keypad_Scan_Jump_Adr+1)
			ijmp
			
Keypad_Scan_Input_Wait:
			lds r16,Keypad_Scan_Key_Val

			cpi r16,'*'
			breq Keypad_Scan_Input_Wait_A

			;Key != *
			rjmp Keypad_Scan_End			;Exit


Keypad_Scan_Input_Wait_A:
			;Key = *
			mov r16,Ticker_Flags
			cbr r16,(1<<Update_LCD1 | 1<<Test_LCD1)
			mov Ticker_Flags,r16			;Disable LCD1 updates/tests

			ldi r16,'1'
			sts Keypad_Scan_Channel,r16		;Channel = 1 (PWM0)

			Set_FIFO_Address LCD_FIFO
			ldi r16,LCD_FIFO_Size
			call FIFO_Init					;clear any pending LCD bytes

			ldi r16,254
			call FIFO_Write

			ldi r16,0b00000001
			call FIFO_Write					;Clear display, adr=0

			rcall Keypad_Scan_Disp_Channel	;display channel

			ldi r16,254
			call FIFO_Write

			ldi r16,0xC0
			call FIFO_Write					;Cursor at Line 2

			ldi ZL,low(String_03<<1)
			ldi ZH,high(String_03<<1)
			rcall Keypad_Scan_Write_Msg		;Line 2 msg

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x94
			call FIFO_Write					;Cursor at Line 3

			ldi ZL,low(String_01<<1)
			ldi ZH,high(String_02<<1)
			rcall Keypad_Scan_Write_Msg		;Line 3 msg

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0xD4
			call FIFO_Write					;Cursor at Line 4

			ldi ZL,low(String_02<<1)
			ldi ZH,high(String_02<<1)
			rcall Keypad_Scan_Write_Msg		;Line 4 msg

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;cursor at pos 0

			ldi r16,254
			call FIFO_Write

			ldi r16,0b00001110
			call FIFO_Write					;cursor on

			ldi r16,low(Keypad_Scan_Channel_Select)
			ldi r17,high(Keypad_Scan_Channel_Select)
		
			sts Keypad_Scan_Jump_Adr,r16	
			sts Keypad_Scan_Jump_Adr+1,r17	;Set jump vector

			rjmp Keypad_Scan_End
			

Keypad_Scan_Channel_Select:
			lds r16,Keypad_Scan_Key_Val

			cpi r16,'*'
			brne Keypad_Scan_Channel_Select_A

			rjmp Keypad_Scan_Star_End		;Exit

Keypad_Scan_Channel_Select_A:
			cpi r16,'#'
			brne Keypad_Scan_Channel_Select_B

			rjmp Keypad_Scan_Channel_Set

Keypad_Scan_Channel_Select_B:
			cpi r16,'1'
			brne Keypad_Scan_Channel_Select_C

			rjmp Keypad_Scan_Channel_Change

Keypad_Scan_Channel_Select_C:
			cpi r16,'2'
			brne Keypad_Scan_Channel_Select_D

			rjmp Keypad_Scan_Channel_Change

Keypad_Scan_Channel_Select_D:
			cpi r16,'3'
			brne Keypad_Scan_Channel_Select_E

			rjmp Keypad_Scan_Channel_Change

Keypad_Scan_Channel_Select_E:
			cpi r16,'4'
			brne Keypad_Scan_Channel_Select_F

			rjmp Keypad_Scan_Channel_Change

Keypad_Scan_Channel_Select_F:
			;ignore keypress
			rjmp Keypad_Scan_End

Keypad_Scan_Channel_Change:
			sts Keypad_Scan_Channel,r16

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;cursor at pos 0

			rcall Keypad_Scan_Disp_Channel	;display channel

			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;cursor at pos 0

			rjmp Keypad_Scan_End

			
Keypad_Scan_Channel_Set:
			lds r16,Keypad_Scan_Channel

			cpi r16,'1'
			brne Keypad_Scan_Channel_Set_A

			in r16,OCR0						;get current PWM
			rjmp Keypad_Scan_Channel_Set_D

Keypad_Scan_Channel_Set_A:
			cpi r16,'2'
			brne Keypad_Scan_Channel_Set_B

			in r16,OCR1AL					;get current PWM
			rjmp Keypad_Scan_Channel_Set_D

Keypad_Scan_Channel_Set_B:
			cpi r16,'3'
			brne Keypad_Scan_Channel_Set_C

			in r16,OCR1BL					;get current PWM
			rjmp Keypad_Scan_Channel_Set_D

Keypad_Scan_Channel_Set_C:
			
			in r16,OCR2						;get current PWM
			rjmp Keypad_Scan_Channel_Set_D

Keypad_Scan_Channel_Set_D:
			clr r17
			call bin2BCD16					;convert to BCD

			call BCD16_ASCII				;convert to ASCII

			sts Keypad_Scan_Input_Val,r18	;store init. value
			sts Keypad_Scan_Input_Val+1,r17
			sts Keypad_Scan_Input_Val+2,r16

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;cursor at pos 0

			rcall Keypad_Scan_Disp_Value	;display value

			ldi r16,254
			call FIFO_Write

			ldi r16,0xC0
			call FIFO_Write					;Cursor at Line 2

			ldi ZL,low(String_04<<1)
			ldi ZH,high(String_04<<1)
			rcall Keypad_Scan_Write_Msg		;Line 2 msg

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;Cursor at Line 1

			ldi r16,low(Keypad_Scan_Input_0)
			ldi r17,high(Keypad_Scan_Input_0)
		
			sts Keypad_Scan_Jump_Adr,r16	
			sts Keypad_Scan_Jump_Adr+1,r17	;Set jump vector

			rjmp Keypad_Scan_End


Keypad_Scan_Input_0:
			lds r16,Keypad_Scan_Key_Val

			cpi r16,'*'
			brne Keypad_Scan_Input_0_A

			rjmp Keypad_Scan_Star_End		;Exit

Keypad_Scan_Input_0_A:
			cpi r16,'#'
			brne Keypad_Scan_Input_0_B

			rjmp Keypad_Set_PWM_End			;Set PWM

Keypad_Scan_Input_0_B:
			cpi r16,'0'
			brne Keypad_Scan_Input_0_C

			rjmp Keypad_Scan_Input_0_F

Keypad_Scan_Input_0_C:
			cpi r16,'1'
			brne Keypad_Scan_Input_0_D

			rjmp Keypad_Scan_Input_0_F

Keypad_Scan_Input_0_D:
			cpi r16,'2'
			brne Keypad_Scan_Input_0_E

			rjmp Keypad_Scan_Input_0_F

Keypad_Scan_Input_0_E:
			;ignore keypress
			rjmp Keypad_Scan_End
			
Keypad_Scan_Input_0_F:
			;key = 0,1,2
			sts Keypad_Scan_Input_Val,r16	;store value

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;cursor at pos 0

			lds r16,Keypad_Scan_Input_Val
			call FIFO_Write

			ldi r16,low(Keypad_Scan_Input_1)
			ldi r17,high(Keypad_Scan_Input_1)
		
			sts Keypad_Scan_Jump_Adr,r16	
			sts Keypad_Scan_Jump_Adr+1,r17	;Set jump vector
			
			rjmp Keypad_Scan_End
			

Keypad_Scan_Input_1:
			lds r16,Keypad_Scan_Key_Val

			cpi r16,'*'
			brne Keypad_Scan_Input_1_A

			rjmp Keypad_Scan_Star_End		;Exit

Keypad_Scan_Input_1_A:
			cpi r16,'#'
			brne Keypad_Scan_Input_1_B

			rjmp Keypad_Set_PWM_End			;Set PWM

Keypad_Scan_Input_1_B:
			lds r17,Keypad_Scan_Input_Val

			cpi r17,'2'
			breq Keypad_Scan_Input_1_C

			rjmp Keypad_Scan_Input_1_D

Keypad_Scan_Input_1_C:
			cpi r16,'6'
			brlo Keypad_Scan_Input_1_D

			;2nd digit = 6 or more and 3rd digit = 2
			;ignore Keypress
			rjmp Keypad_Scan_End


Keypad_Scan_Input_1_D:
			sts Keypad_Scan_Input_Val+1,r16	;store value

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x81
			call FIFO_Write					;cursor at pos 1

			lds r16,Keypad_Scan_Input_Val+1
			call FIFO_Write

			ldi r16,low(Keypad_Scan_Input_2)
			ldi r17,high(Keypad_Scan_Input_2)
		
			sts Keypad_Scan_Jump_Adr,r16	
			sts Keypad_Scan_Jump_Adr+1,r17	;Set jump vector
			
			rjmp Keypad_Scan_End


Keypad_Scan_Input_2:
			lds r16,Keypad_Scan_Key_Val

			cpi r16,'*'
			brne Keypad_Scan_Input_2_A

			rjmp Keypad_Scan_Star_End		;Exit

Keypad_Scan_Input_2_A:
			cpi r16,'#'
			brne Keypad_Scan_Input_2_B

			rjmp Keypad_Set_PWM_End			;Set PWM

Keypad_Scan_Input_2_B:
			lds r17,Keypad_Scan_Input_Val

			cpi r17,'2'
			breq Keypad_Scan_Input_2_C

			rjmp Keypad_Scan_Input_2_E

Keypad_Scan_Input_2_C:
			lds r18,Keypad_Scan_Input_Val+1

			cpi r18,'5'
			breq Keypad_Scan_Input_2_D

			rjmp Keypad_Scan_Input_2_E

Keypad_Scan_Input_2_D:
			cpi r16,'6'
			brlo Keypad_Scan_Input_2_E

			;attempted number > 255
			;ignore keypress
			rjmp Keypad_Scan_End


Keypad_Scan_Input_2_E:
			sts Keypad_Scan_Input_Val+2,r16	;store value

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0x82
			call FIFO_Write					;cursor at pos 2

			lds r16,Keypad_Scan_Input_Val+2
			call FIFO_Write

			ldi r16,254
			call FIFO_Write

			ldi r16,0x80
			call FIFO_Write					;cursor at pos 0

			ldi r16,low(Keypad_Scan_Input_0)
			ldi r17,high(Keypad_Scan_Input_0)
		
			sts Keypad_Scan_Jump_Adr,r16	
			sts Keypad_Scan_Jump_Adr+1,r17	;Set jump vector
			
			rjmp Keypad_Scan_End


Keypad_Set_PWM_End:
			lds r18,Keypad_Scan_Input_Val
			lds r17,Keypad_Scan_Input_Val+1
			lds r16,Keypad_Scan_Input_Val+2

			subi r18,48
			subi r17,48
			subi r16,48					;r16 = 1st digit

			ldi r19,100
			mul r18,r19
			add r16,r0					;r16 = 1st + 3rd digit

			ldi r19,10
			mul r17,r19
			add r16,r0					;r16 = 1st + 3rd + 2nd digit
										;(binary)

			lds r17,Keypad_Scan_Channel

			cpi r17,'1'
			brne Keypad_Set_PWM_End_A

			out OCR0,r16				;set PWM value
			rjmp Keypad_Set_PWM_End_D


Keypad_Set_PWM_End_A:
			cpi r17,'2'
			brne Keypad_Set_PWM_End_B

			out OCR1AL,r16
			rjmp Keypad_Set_PWM_End_D


Keypad_Set_PWM_End_B:
			cpi r17,'3'
			brne Keypad_Set_PWM_End_C

			out OCR1BL,r16
			rjmp Keypad_Set_PWM_End_D


Keypad_Set_PWM_End_C:
			;channel = 4
			out OCR2,r16
			rjmp Keypad_Set_PWM_End_D

Keypad_Set_PWM_End_D:

Keypad_Scan_Star_End:
			ldi r16,low(Keypad_Scan_Input_Wait)
			ldi r17,high(Keypad_Scan_Input_Wait)
		
			sts Keypad_Scan_Jump_Adr,r16
			sts Keypad_Scan_Jump_Adr+1,r17	;Set Jump vector to Input_Wait

			mov r16,Ticker_Flags
			sbr r16,(1<<Update_LCD1 | 1<<Test_LCD1)
			mov Ticker_Flags,r16			;enable LCD1 updates/tests

			clr LCD_C1L
			clr LCD_C1H						;clear LCD1 ticker coutner

			Set_FIFO_Address LCD_FIFO
			ldi r16,254
			call FIFO_Write

			ldi r16,0b00001100
			call FIFO_Write					;Turn cursor off
																
			;Set row drivers low
Keypad_Scan_End:
			in r16,PORTB
			cbr r16,0b11110000
			out PORTB,r16

			;temp
			in r16,PORTB
			cbr r16,0b00000001
			out PORTB,r16

			;Stop Keypad_C0 from updates and tests
			mov r16,Ticker_Flags
			cbr r16,(1<<Update_Keypad | 1<<Test_Keypad)
			mov Ticker_Flags,r16

			;clear flags
			ldi r16,(1<<INTF1 | 1<<INTF0 | 1<<INTF2)
			out GIFR,r16		

			;Re-enable INT0,1,2 interrupts	
			in r16,GICR
			sbr r16,(1<<INT0 | 1<<INT1 | 1<<INT2)
			out GICR,r16

			ret

Keypad_Scan_Disp_Channel:
			lds r16,Keypad_Scan_Channel
			call FIFO_Write

			ldi r16,LCD_Separator
			call FIFO_Write

			ldi r16,'('
			call FIFO_Write

			lds r16,Keypad_Scan_Channel
			cpi r16,'1'

			brne Keypad_Scan_Disp_Channel_A

			ldi XL,low(PWM0_Name)
			ldi XH,high(PWM0_Name)

			rjmp Keypad_Scan_Disp_Channel_D

Keypad_Scan_Disp_Channel_A:
			cpi r16,'2'
			
			brne Keypad_Scan_Disp_Channel_B
			
			ldi XL,low(PWM1_Name)
			ldi XH,high(PWM1_Name)
			
			rjmp Keypad_Scan_Disp_Channel_D
			
Keypad_Scan_Disp_Channel_B:
			cpi r16,'3'
			
			brne Keypad_Scan_Disp_Channel_C
			
			ldi XL,low(PWM2_Name)
			ldi XH,high(PWM2_Name)
			
			rjmp Keypad_Scan_Disp_Channel_D
			
Keypad_Scan_Disp_Channel_C:
			ldi XL,low(PWM3_Name)
			ldi XH,high(PWM3_Name)
			
Keypad_Scan_Disp_Channel_D:											

			ld r19,X+					;r19 = character count

			ldi r20,16
			sub r20,r19					;r20 = tailing spaces required

Keypad_Scan_Disp_Channel_E:
			ld r16,X+					;get character
			call FIFO_Write				;send character

			dec r19

			brne Keypad_Scan_Disp_Channel_E

			ldi r16,')'
			call FIFO_Write

			ldi r16,' '

Keypad_Scan_Disp_Channel_F:
			call FIFO_Write

			dec r20

			brne Keypad_Scan_Disp_Channel_F

			ret

Keypad_Scan_Disp_Value:
			lds r16,Keypad_Scan_Input_Val
			call FIFO_Write

			lds r16,Keypad_Scan_Input_Val+1
			call FIFO_Write

			lds r16,Keypad_Scan_Input_Val+2
			call FIFO_Write

			ldi r16,LCD_Separator
			call FIFO_Write

			ldi r16,'('
			call FIFO_Write

			lds r16,Keypad_Scan_Channel
			cpi r16,'1'

			brne Keypad_Scan_Disp_Value_A

			ldi XL,low(PWM0_Name)
			ldi XH,high(PWM0_Name)

			rjmp Keypad_Scan_Disp_Value_D

Keypad_Scan_Disp_Value_A:
			cpi r16,'2'
			
			brne Keypad_Scan_Disp_Value_B
			
			ldi XL,low(PWM1_Name)
			ldi XH,high(PWM1_Name)
			
			rjmp Keypad_Scan_Disp_Value_D
			
Keypad_Scan_Disp_Value_B:
			cpi r16,'3'
			
			brne Keypad_Scan_Disp_Value_C
			
			ldi XL,low(PWM2_Name)
			ldi XH,high(PWM2_Name)
			
			rjmp Keypad_Scan_Disp_Value_D

Keypad_Scan_Disp_Value_C:
			ldi XL,low(PWM3_Name)
			ldi XH,high(PWM3_Name)
			
Keypad_Scan_Disp_Value_D:											

			ld r19,X+					;r19 = character count

			ldi r20,14
			sub r20,r19					;r20 = tailing spaces required

Keypad_Scan_Disp_Value_E:
			ld r16,X+					;get character
			call FIFO_Write				;send character

			dec r19

			brne Keypad_Scan_Disp_Value_E

			ldi r16,')'
			call FIFO_Write

			ldi r16,' '

Keypad_Scan_Disp_Value_F:
			call FIFO_Write

			dec r20

			brne Keypad_Scan_Disp_Value_F

			ret


Keypad_Scan_Write_Msg:
			lpm r19,Z+					;Get character number

Keypad_Scan_Write_Msg_A:
			lpm r16,Z+					;Get character

			push ZL
			push ZH						;save Z

			Set_FIFO_Address LCD_FIFO
			call FIFO_Write				;Write character

			pop ZH
			pop ZL						;restore Z

			dec r19

			brne Keypad_Scan_Write_Msg_A

			ret
			


			